// C Source File
// Created 3/5/2005; 9:53:49 AM

#include <tigcclib.h>

#include "BasicTypes.h"

#ifdef USE_TI89
#define TOTAL_ROWS 7
#else
#define TOTAL_ROWS 10
#endif

short rowValue[TOTAL_ROWS];

void ReadKeyboard(void)
{
	short row;

	for (row = 0; row < TOTAL_ROWS; row++)
	{
		rowValue[row] = _rowread(~((short)(1<<row)));
	}
}

KeyboardInput GetFunctionKeyPress(int2 allowRepeat)
{
	static KeyboardInput lastKeyPress = KBD_NoKey;
	KeyboardInput keyPress = KBD_NoKey;

	ReadKeyboard();

#ifndef USE_TI89

	if (rowValue[5] & 1<<7)      // F1
		keyPress = KBD_F1;
	else if (rowValue[4] & 1<<7) // F2
		keyPress = KBD_F2;
	else if (rowValue[3] & 1<<7) // F3
		keyPress = KBD_F3;
	else if (rowValue[2] & 1<<7) // F4
		keyPress = KBD_F4;
	else if (rowValue[1] & 1<<7) // F5
		keyPress = KBD_F5;

#else

	if (rowValue[6] & 1<<4)      // F1
		keyPress = KBD_F1;
	else if (rowValue[4] & 1<<4) // F2
		keyPress = KBD_F2;
	else if (rowValue[2] & 1<<4) // F3
		keyPress = KBD_F3;
	else if (rowValue[9] & 1<<4) // F4
		keyPress = KBD_F4;
	else if (rowValue[7] & 1<<4) // F5
		keyPress = KBD_F5;
	else if (rowValue[5] & 1<<4) // F6
		keyPress = KBD_F6;
	else if (rowValue[3] & 1<<4) // F7
		keyPress = KBD_F7;
	else if (rowValue[1] & 1<<4) // F8
		keyPress = KBD_F8;

#endif

	if (!allowRepeat)
	{
		if (keyPress == lastKeyPress)
			keyPress = KBD_NoKey;
		else
			lastKeyPress = keyPress;
	}

	return keyPress;
}

KeyboardInput GetModifierKeyPress(int2 allowRepeat)
{
	static KeyboardInput lastKeyPress = KBD_NoKey;
	KeyboardInput keyPress = KBD_NoKey;

	ReadKeyboard();

#ifdef USE_TI89

	if (rowValue[0] & 1<<5)      // Shift
		keyPress = KBD_Shift;
	else if (rowValue[0] & 1<<6) // Diamond
		keyPress = KBD_Diamond;
	else if (rowValue[0] & 1<<7) // Alpha
		keyPress = KBD_Alpha;
	else if (rowValue[0] & 1<<4) // 2nd
		keyPress = KBD_2nd;

#else

	if (rowValue[0] & 1<<2)      // Shift
		keyPress = KBD_Shift;
	else if (rowValue[0] & 1<<1) // Diamond
		keyPress = KBD_Diamond;
	else if (rowValue[0] & 1<<0) // 2nd
		keyPress = KBD_2nd;

#endif

	if (!allowRepeat)
	{
		if (keyPress == lastKeyPress)
			keyPress = KBD_NoKey;
		else
			lastKeyPress = keyPress;
	}

	return keyPress;
}

KeyboardInput GetDirectionKeyPress(int2 allowRepeat)
{
	static KeyboardInput lastKeyPress = KBD_NoKey;
	KeyboardInput keyPress = KBD_NoKey;

	short localRowValue = rowValue[0];

	ReadKeyboard();

#ifdef USE_TI89

	if (localRowValue & 1<<1)        // Left
	{
		if (localRowValue & 1<<0)      // Up
			keyPress = KBD_UpLeft;
		else if (localRowValue & 1<<2) // Down
			keyPress = KBD_DownLeft;
		else
			keyPress = KBD_Left;
	}
	else if (localRowValue & 1<<3)   // Right
	{
		if (localRowValue & 1<<0)      // Up
			keyPress = KBD_UpRight;
		else if (localRowValue & 1<<2) // Down
			keyPress = KBD_DownRight;
		else
			keyPress = KBD_Right;
	}
	else if (localRowValue & 1<<0)   // Up
		keyPress = KBD_Up;
	else if (localRowValue & 1<<2)   // Down
		keyPress = KBD_Down;

#else

	if (localRowValue & 1<<4)        // Left
	{
		if (localRowValue & 1<<5)      // Up
			keyPress = KBD_UpLeft;
		else if (localRowValue & 1<<7) // Down
			keyPress = KBD_DownLeft;
		else
			keyPress = KBD_Left;
	}
	else if (localRowValue & 1<<6)   // Right
	{
		if (localRowValue & 1<<5)      // Up
			keyPress = KBD_UpRight;
		else if (localRowValue & 1<<7) // Down
			keyPress = KBD_DownRight;
		else
			keyPress = KBD_Right;
	}
	else if (localRowValue & 1<<5)   // Up
		keyPress = KBD_Up;
	else if (localRowValue & 1<<7)   // Down
		keyPress = KBD_Down;

#endif

	if (!allowRepeat)
	{
		if (keyPress == lastKeyPress)
			keyPress = KBD_NoKey;
		else
			lastKeyPress = keyPress;
	}

	return keyPress;
}

KeyboardInput GetKeyPress(int2 allowRepeat)
{
	static KeyboardInput lastKeyPress = KBD_NoKey;
	KeyboardInput keyPress = KBD_NoKey;

	ReadKeyboard();

#ifdef USE_TI89

	if (rowValue[1] & 1<<6) // Clear
		keyPress = KBD_Clear;
	else if (rowValue[1] & 1<<5) // ^
		keyPress = KBD_Power;
	else if (rowValue[1] & 1<<4) // /
		keyPress = KBD_Divide;
	else if (rowValue[1] & 1<<3) // *
		keyPress = KBD_Multiply;
	else if (rowValue[1] & 1<<2) // -
		keyPress = KBD_Minus;
	else if (rowValue[1] & 1<<1) // +
		keyPress = KBD_Plus;
	else if (rowValue[1] & 1<<0) // Enter
		keyPress = KBD_Enter;

	else if (rowValue[2] & 1<<6) // Backspace
		keyPress = KBD_Backspace;
	else if (rowValue[2] & 1<<5) // t
		keyPress = KBD_T;
	else if (rowValue[2] & 1<<4) // ,
		keyPress = KBD_Comma;
	else if (rowValue[2] & 1<<3) // 9
		keyPress = KBD_9;
	else if (rowValue[2] & 1<<2) // 6
		keyPress = KBD_6;
	else if (rowValue[2] & 1<<1) // 3
		keyPress = KBD_3;
	else if (rowValue[2] & 1<<0) // (-)
		keyPress = KBD_Negate;

	else if (rowValue[3] & 1<<6) // Catalog
		keyPress = KBD_Catalog;
	else if (rowValue[3] & 1<<5) // z
		keyPress = KBD_Z;
	else if (rowValue[3] & 1<<4) // )
		keyPress = KBD_ClosePar;
	else if (rowValue[3] & 1<<3) // 8
		keyPress = KBD_8;
	else if (rowValue[3] & 1<<2) // 5
		keyPress = KBD_5;
	else if (rowValue[3] & 1<<1) // 2
		keyPress = KBD_2;
	else if (rowValue[3] & 1<<0) // .
		keyPress = KBD_Period;

	else if (rowValue[4] & 1<<6) // Mode
		keyPress = KBD_Mode;
	else if (rowValue[4] & 1<<5) // y
		keyPress = KBD_Y;
	else if (rowValue[4] & 1<<4) // (
		keyPress = KBD_OpenPar;
	else if (rowValue[4] & 1<<3) // 7
		keyPress = KBD_7;
	else if (rowValue[4] & 1<<2) // 4
		keyPress = KBD_4;
	else if (rowValue[4] & 1<<1) // 1
		keyPress = KBD_1;
	else if (rowValue[4] & 1<<0) // 0
		keyPress = KBD_0;

	else if (rowValue[5] & 1<<6) // Home
		keyPress = KBD_Home;
	else if (rowValue[5] & 1<<5) // x
		keyPress = KBD_X;
	else if (rowValue[5] & 1<<4) // =
		keyPress = KBD_Equals;
	else if (rowValue[5] & 1<<3) // |
		keyPress = KBD_Or;
	else if (rowValue[5] & 1<<2) // ee
		keyPress = KBD_EE;
	else if (rowValue[5] & 1<<1) // Sto
		keyPress = KBD_Sto;
	else if (rowValue[5] & 1<<0) // Apps
		keyPress = KBD_Apps;

	else if (rowValue[6] & 1<<0) // Esc
		keyPress = KBD_Esc;

#else

	if (rowValue[9] & 1<<1)      // Enter1
		keyPress = KBD_Enter;
	else if (rowValue[6] & 1<<6) // Enter2
		keyPress = KBD_Enter;

	else if (rowValue[7] & 1<<6) // Apps
		keyPress = KBD_Apps;
	else if (rowValue[8] & 1<<5) // Mode
		keyPress = KBD_Mode;
	else if (rowValue[7] & 1<<5) // Clear
		keyPress = KBD_Catalog;
	else if (rowValue[6] & 1<<5) // Ln
		keyPress = KBD_Ln;
	else if (rowValue[5] & 1<<5) // Sin
		keyPress = KBD_Sin;
	else if (rowValue[5] & 1<<6) // Cos
		keyPress = KBD_Cos;
	else if (rowValue[5] & 1<<7) // Tan
		keyPress = KBD_Tan;
	else if (rowValue[8] & 1<<1) // Theta
		keyPress = KBD_Theta;
	else if (rowValue[3] & 1<<0) // Sto
		keyPress = KBD_Apps;
	else if (rowValue[8] & 1<<0) // Backspace
		keyPress = KBD_Backspace;
	else if (rowValue[6] & 1<<0) // ^
		keyPress = KBD_Power;
	else if (rowValue[4] & 1<<5) // (
		keyPress = KBD_OpenPar;
	else if (rowValue[4] & 1<<6) // )
		keyPress = KBD_ClosePar;
	else if (rowValue[4] & 1<<7) // ,
		keyPress = KBD_Comma;
	else if (rowValue[5] & 1<<0) // /
		keyPress = KBD_Divide;
	else if (rowValue[7] & 1<<7) // *
		keyPress = KBD_Multiply;
	else if (rowValue[9] & 1<<0) // -
		keyPress = KBD_Minus;
	else if (rowValue[8] & 1<<4) // +
		keyPress = KBD_Plus;
	else if (rowValue[7] & 1<<0) // =
		keyPress = KBD_Apps;

	else if (rowValue[9] & 1<<2) // a
		keyPress = KBD_A;
	else if (rowValue[5] & 1<<1) // b
		keyPress = KBD_B;
	else if (rowValue[3] & 1<<1) // c
		keyPress = KBD_C;
	else if (rowValue[2] & 1<<2) // d
		keyPress = KBD_D;
	else if (rowValue[2] & 1<<3) // e
		keyPress = KBD_E;
	else if (rowValue[3] & 1<<2) // f
		keyPress = KBD_F;
	else if (rowValue[4] & 1<<2) // g
		keyPress = KBD_G;
	else if (rowValue[5] & 1<<2) // h
		keyPress = KBD_H;
	else if (rowValue[7] & 1<<3) // i
		keyPress = KBD_I;
	else if (rowValue[6] & 1<<2) // j
		keyPress = KBD_J;
	else if (rowValue[7] & 1<<2) // k
		keyPress = KBD_K;
	else if (rowValue[8] & 1<<2) // l
		keyPress = KBD_L;
	else if (rowValue[7] & 1<<1) // m
		keyPress = KBD_M;
	else if (rowValue[6] & 1<<1) // n
		keyPress = KBD_N;
	else if (rowValue[8] & 1<<3) // o
		keyPress = KBD_O;
	else if (rowValue[6] & 1<<7) // p
		keyPress = KBD_P;
	else if (rowValue[9] & 1<<3) // q
		keyPress = KBD_Q;
	else if (rowValue[3] & 1<<3) // r
		keyPress = KBD_R;
	else if (rowValue[1] & 1<<2) // s
		keyPress = KBD_S;
	else if (rowValue[4] & 1<<3) // t
		keyPress = KBD_T;
	else if (rowValue[6] & 1<<3) // u
		keyPress = KBD_U;
	else if (rowValue[4] & 1<<1) // v
		keyPress = KBD_V;
	else if (rowValue[1] & 1<<3) // w
		keyPress = KBD_W;
	else if (rowValue[2] & 1<<1) // x
		keyPress = KBD_X;
	else if (rowValue[5] & 1<<3) // y
		keyPress = KBD_Y;
	else if (rowValue[1] & 1<<1) // z
		keyPress = KBD_Z;
	else if (rowValue[4] & 1<<0) // space
		keyPress = KBD_Space;
	else if (rowValue[9] & 1<<5) // 0
		keyPress = KBD_0;
	else if (rowValue[1] & 1<<5) // 1
		keyPress = KBD_1;
	else if (rowValue[1] & 1<<6) // 2
		keyPress = KBD_2;
	else if (rowValue[1] & 1<<7) // 3
		keyPress = KBD_3;
	else if (rowValue[2] & 1<<5) // 4
		keyPress = KBD_4;
	else if (rowValue[2] & 1<<6) // 5
		keyPress = KBD_5;
	else if (rowValue[2] & 1<<7) // 6
		keyPress = KBD_6;
	else if (rowValue[3] & 1<<5) // 7
		keyPress = KBD_7;
	else if (rowValue[3] & 1<<6) // 8
		keyPress = KBD_8;
	else if (rowValue[3] & 1<<7) // 9
		keyPress = KBD_9;

	else if (rowValue[8] & 1<<6) // Esc
		keyPress = KBD_Esc;

#endif

	if (!keyPress)
		keyPress = GetDirectionKeyPress(allowRepeat);

	if (!keyPress)
		keyPress = GetFunctionKeyPress(allowRepeat);

	keyPress |= GetModifierKeyPress(allowRepeat);

	if (!allowRepeat)
	{
		if (keyPress == lastKeyPress)
			keyPress = KBD_NoKey;
		else
			lastKeyPress = keyPress;
	}

	return keyPress;
}

char* GetCharInput(void)
{
	return NULL;
}

